﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CodeSystemGet]') AND type in (N'P', N'PC'))
BEGIN 
	DROP PROCEDURE [hips].[CodeSystemGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date: 15 Oct 2012
-- Description:   Gets all or a specific record from the CodeSystem Table
-- =============================================
CREATE PROCEDURE [hips].[CodeSystemGet] 
(
	@CodeSystemId INT = null
	,@DateModified DATETIME = null
)
AS
BEGIN
SELECT  c.CodeSystemId,
		c.Code,
		c.Description,
		c.Oid,
		c.Version,
		c.HL7FieldPosition,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified
		
FROM  hips.CodeSystem c
WHERE (c.CodeSystemId = @CodeSystemId OR @CodeSystemId IS NULL)
AND (c.DateModified < @DateModified OR @DateModified IS NULL)
ORDER BY c.Description asc
END
